%  Description: This function codes and write an output file using a split 
%               vector quantization given a series of vectors with 
%               coefficents partitioned into N groups
% 
%  Call Syntax: encode(outfile,VECTORS,CoeffGroups,GroupBits,ReconstructionLvls)
% 
%  Input Arguments:
% 	Name: outfile
% 	Type: string 
% 	Description: name of binary ouput file to be writen.
% 
% 	Name: VECTORS
% 	Type: martix (D-dimensional vector X number of vectors)
% 	Description: A matrix of vectors to be quantized, each vector should 
%                 be one column of the matrix.
% 
% 	Name: CoeffGroups
% 	Type: cell array
% 	Description: A 1xN cell array in which the n'th cell contains a list of
% 	coeffecients that are elements of the n'th group.
% 
% 	Name: GroupBits
% 	Type: vector
% 	Description: a 1xN vector containing the number of bits the n'th group
% 	it to be coded with.
% 
% 	Name: ReconstructionLvls
% 	Type: cell array 
% 	Description: A 1xN cell array in which the n'th cell contains the
% 	reconstruction levels of the n'th group.
% 
%  Output: A coded series of vectors with name specified by outfile .
%          
%    Data structure is a follows: 
% 
%      10BITS               - THE VECTOR DIMENSION
%      64BITS               - THE NUMBER OF VECTORS TO FOLLOW
%      USER SPECIFIED BITS  - CODEWORD FOR GROUP 1, VECTOR1
%      USER SPECIFIED BITS  - CODEWORD FOR GROUP 2, VECTOR1
%            ...                         ...
%      USER SPECIFIED BITS  - CODEWORD FOR GROUP N, VECTOR1
%      USER SPECIFIED BITS  - CODEWORD FOR GROUP 1, VECTOR2
%      USER SPECIFIED BITS  - CODEWORD FOR GROUP 2, VECTOR2
%            ...                         ...
%      USER SPECIFIED BITS  - CODEWORD FOR GROUP N, VECTOR2
%            ...                         ...
% 
%      *GROUPS ALLOCATED 0 BITS ARE SKIPED
% 
%  Creation Date:
%  Last Revision:
% 
%  Required subroutines: 
% 
%  Notes:
% 
%  References:
% *************************************************************************
%
